<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class Flight extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->resource['id'],
            'cia' => $this->resource['cia'],
            'fare' => $this->resource['fare'],
            'flightNumber' => $this->resource['flightNumber'],
            'origin' => $this->resource['origin'],
            'destination' => $this->resource['destination'],
            'departureDate' => $this->resource['departureDate'],
            'departureTime' => $this->resource['departureTime'],
            'departureDateUSFormat' => Carbon::createFromFormat('d/m/Y', $this->resource['departureDate'])
                ->format('Y-m-d'),
            'arrivalDate' => $this->resource['arrivalDate'],
            'arrivalTime' => $this->resource['arrivalTime'],
            'arrivalDateUSFormat' => Carbon::createFromFormat('d/m/Y', $this->resource['arrivalDate'])
                ->format('Y-m-d'),
            'classService' => $this->resource['classService'],
            'price' => $this->resource['price'],
            'tax' => $this->resource['tax'],
            'outbound' => $this->resource['outbound'],
            'inbound' => $this->resource['inbound'],
            'duration' => $this->resource['duration'],
        ];
    }

    /**
     * @return bool
     */
    public function isInbound(): bool
    {
        return $this->resource['inbound'] == 1;
    }

    /**
     * @return bool
     */
    public function isOutbound(): bool
    {
        return $this->resource['outbound'] == 1;
    }

    /**
     * @param string $fare
     * @return bool
     */
    public function isFare(string $fare): bool
    {
        return $this->resource['fare'] == $fare;
    }
}
