<?php

namespace App\Http\Controllers\API;

use App\Repository\FlightRepository;
use Illuminate\Support\Facades\Cache;

/**
 * Flight
 *
 * @package App\Http\Controllers\API
 */
class Flight
{
    public function getAllFlights()
    {
        if (Cache::has('getAllFlights')) {
            return Cache::get('getAllFlights');
        }

        $flights = new FlightRepository();
        $response = $flights->getAllFlights();

        Cache::put('getAllFlights', $response, env('CACHE_TIME_IN_SECONDS', 60));

        return $response;
    }

    public function getAllInboundFlights()
    {
        if (Cache::has('getAllInboundFlights')) {
            return Cache::get('getAllInboundFlights');
        }

        $flights = new FlightRepository();
        $response = $flights->getAllInboundFlights();

        Cache::put('getAllInboundFlights', $response, env('CACHE_TIME_IN_SECONDS', 60));

        return $response;
    }

    public function getAllOutboundFlights()
    {
        if (Cache::has('getAllOutboundFlights')) {
            return Cache::get('getAllOutboundFlights');
        }

        $flights = new FlightRepository();
        $response = $flights->getAllOutboundFlights();

        Cache::put('getAllOutboundFlights', $response, env('CACHE_TIME_IN_SECONDS', 60));

        return $response;
    }

    public function getAllGroupsFlights()
    {
        if (Cache::has('getAllGroupsFlights')) {
            return Cache::get('getAllGroupsFlights');
        }

        $flights = new FlightRepository();
        $response = $flights->getAllGroupsFlights();

        Cache::put('getAllGroupsFlights', $response, env('CACHE_TIME_IN_SECONDS', 60));

        return $response;
    }
}
